<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('spatial.legend', function (Blueprint $table) {
            $table->uuid('id')
                ->primary()
                ->default(DB::raw('gen_random_uuid()'));
            $table->string('name')->unique();
            $table->string('table');
            $table->enum('type', ['POLYGON', 'LINE', 'POINT'])->default('POLYGON');
            $table->string('stroke_color');
            $table->float('stroke_width');
            $table->string('fill_color')->nullable();
            $table->string('layer_name');
            $table->integer('zindex')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('spatial.legend');
    }
};
