<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('codelist.data_licences', function (Blueprint $table) {
            $table->uuid('id')
            ->primary()
            ->default(DB::raw('gen_random_uuid()'))->unique();
            $table->string('name')->unique();
            $table->text('description');
            $table->timestamps();
        });
        DB::table('codelist.data_licences')->insert([
            'name' => 'data_licence_commercial_name',
            'description' => 'data_licence_commercial_description',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        DB::table('codelist.data_licences')->insert([
            'name' => 'data_licence_copyleft_name',
            'description' => 'data_licence_copyleft_description',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        DB::table('codelist.data_licences')->insert([
            'name' => 'data_licence_free_name',
            'description' => 'data_licence_free_description',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        DB::table('codelist.data_licences')->insert([
            'name' => 'data_licence_restricted_name',
            'description' => 'data_licence_restricted_description',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('codelist.data_licences');
    }
};
