<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tabular.thematics', function (Blueprint $table) {
            $table->uuid('id')
            ->primary()
            ->default(DB::raw('gen_random_uuid()'))->unique();
            $table->string('name')->unique();
            $table->text('definition')->nullable();
            $table->string('source')->nullable();
            $table->string('source_link')->nullable();
            $table->uuid('category_thematic_id');
            $table->foreign('category_thematic_id')->references('id')->on('codelist.thematic_categories')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tabular.thematics');
    }
};
