<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('codelist.user_roles', function (Blueprint $table) {
            $table->uuid('id')
                ->primary()
                ->default(DB::raw('gen_random_uuid()'))
                ->unique();
            $table->string('name')->unique();
            $table->timestamps();
        });
        DB::table('codelist.user_roles')->insert([
            'name' => 'user_role_viewer',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        DB::table('codelist.user_roles')->insert([
            'name' => 'user_role_editor',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        DB::table('codelist.user_roles')->insert([
            'name' => 'user_role_administrator',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('codelist.user_roles');
    }
};
