<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tabular.documents', function (Blueprint $table) {
            $table->uuid('id')
            ->primary()
            ->default(DB::raw('gen_random_uuid()'))->unique();
            $table->string('name');
            $table->string('type');
            $table->text('description')->nullable();
            $table->integer('size');
            $table->timestamp('publication_date')->nullable();
            $table->text('author')->nullable();
            $table->string('edition_year', length: 4)->nullable();
            $table->text('path');
            $table->uuid('project_id');
            $table->foreign('project_id')->references('id')->on('tabular.projects')->onDelete('cascade');
            $table->uuid('user_id');
            $table->foreign('user_id')->references('user_id')->on('users')->onDelete('cascade');
            $table->uuid('role_id');
            $table->foreign('role_id')->references('id')->on('codelist.user_roles')->onDelete('cascade');
            $table->string('field')->nullable();
            $table->uuid('location_id')->nullable()->references('id')->on('codelist.project_locations')->onDelete('cascade');
            $table->uuid('author_organization_id')->nullable()->references('id')->on('tabular.organizations')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tabular.documents');
    }
};
