<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('codelist.collection_methods', function (Blueprint $table) {
            $table->uuid('id')
            ->primary()
            ->default(DB::raw('gen_random_uuid()'))->unique();
            $table->string('name')->unique();
            $table->timestamps();
        });
        DB::table('codelist.collection_methods')->insert([
            'name' => 'collection_method_interviews',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        DB::table('codelist.collection_methods')->insert([
            'name' => 'collection_method_surveys',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        DB::table('codelist.collection_methods')->insert([
            'name' => 'collection_method_observation',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        DB::table('codelist.collection_methods')->insert([
            'name' => 'collection_method_documents_and_or_records',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        DB::table('codelist.collection_methods')->insert([
            'name' => 'collection_method_discussion_group',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('codelist.collection_methods');
    }
};
