<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tabular.projects', function (Blueprint $table) {
            $table->uuid('id')
            ->primary()
            ->default(DB::raw('gen_random_uuid()'))->unique();
            $table->string('name')->unique();
            $table->string('field')->nullable();
            $table->string('logo')->nullable();
            $table->string('logo_copyright')->nullable();
            $table->uuid('location_id')->nullable();
            $table->foreign('location_id')->references('id')->on('codelist.project_locations')->onDelete('cascade');
            $table->timestamp('start_date')->nullable();
            $table->timestamp('end_date')->nullable();
            $table->integer('budget')->nullable();
            $table->uuid('currency_id')->nullable();
            $table->foreign('currency_id')->references('id')->on('codelist.currency')->onDelete('cascade');
            $table->uuid('organization_id');
            $table->foreign('organization_id')->references('id')->on('tabular.organizations')->onDelete('cascade');
            $table->uuid('user_id');
            $table->foreign('user_id')->references('user_id')->on('users')->onDelete('cascade');
            $table->string('website')->nullable();
            $table->string('manager_name')->nullable();
            $table->string('manager_email')->nullable();
            $table->string('manager_phone')->nullable();
            $table->string('focal_point_name')->nullable();
            $table->string('focal_point_email')->nullable();
            $table->string('focal_point_phone')->nullable();
            $table->text('main_objective')->nullable();
            $table->timestamps();
        });
    }
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tabular.projects');
    }
};
