<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('codelist.project_locations', function (Blueprint $table) {
            $table->uuid('id')
                ->primary()
                ->default(DB::raw('gen_random_uuid()'))
                ->unique();
            $table->string('name')->unique();
            $table->timestamps();
        });
        DB::table('codelist.project_locations')->insert([
            'name' => 'location_cameroon',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        DB::table('codelist.project_locations')->insert([
            'name' => 'location_congo',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        DB::table('codelist.project_locations')->insert([
            'name' => 'location_gabon',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        DB::table('codelist.project_locations')->insert([
            'name' => 'location_tridom',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        DB::table('codelist.project_locations')->insert([
            'name' => 'location_cameroon_congo',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        DB::table('codelist.project_locations')->insert([
            'name' => 'location_cameroon_gabon',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        DB::table('codelist.project_locations')->insert([
            'name' => 'location_congo_gabon',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('codelist.project_locations');
    }
};
