<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ProjectController;
use App\Http\Controllers\OrganizationController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\AccountController;
use App\Http\Middleware\EnsureHasAuthorizationHeader;
use App\Http\Controllers\ThematicController;
use App\Http\Controllers\DocumentController;
use App\Http\Controllers\IndicatorController;

Route::get('api/locales', function (Request $request) {
    $locale="fr";
    if (! in_array($locale, ['en', 'fr'])) {
        return response()->json(['message' => 'Unsupported locale'], 400);
    }

    // Return translations (for frontend)
    $translations = file_get_contents(base_path()."/locales/$locale.json");
    return response()->json([
        'message' => 'Localization files generated successfully',
        'locale' => $locale,
        'translations' => json_decode($translations, true)
    ]);
});
Route::post('api/login', [AuthController::class, 'login']);

Route::get('api/phpinfo', function () {
    phpinfo();
});

Route::controller(ProjectController::class)->group(function () {
    Route::get('api/projects', 'index');
    Route::get('api/project/objectives', 'getObjectives');
    Route::get('api/project/results', 'getResults');
    Route::get('api/project/thematics', 'getThematics');
    Route::get('api/project/{id}', 'info');
});

Route::controller(DocumentController::class)->group(function () {
    Route::get('api/documents/public', [DocumentController::class, 'public']);
    Route::get('api/pictures', [DocumentController::class, 'pictures']);
});

Route::controller(OrganizationController::class)->group(function () {
    Route::get('api/organizations', 'index');
});

Route::controller(ThematicController::class)->group(function () {
    Route::get('api/thematics', 'index');
});

Route::controller(IndicatorController::class)->group(function () {
    Route::get('/api/spatial/legend', 'index');
});

Route::middleware([EnsureHasAuthorizationHeader::class, 'auth:sanctum'])->group(function () {

    Route::controller(IndicatorController::class)->group(function () {
        Route::post('api/spatial/legend', 'storeLegend');
        Route::patch('/api/spatial/legend/{id}', 'updateLegend');
        Route::delete('api/spatial/legend/{id}', 'deleteLegend');
        Route::patch('/api/spatial/table/{table}/{id}', 'updateSpatialDataTable');
    });

    Route::controller(AccountController::class)->group(function () {
        Route::post('api/accounts', 'store');
    });

    Route::controller(DocumentController::class)->group(function () {
        Route::get('api/documents', [DocumentController::class, 'index']);
        Route::post('api/documents', [DocumentController::class, 'store']);
        Route::post('api/picture', [DocumentController::class, 'storePicture']);
        Route::delete('api/document/{id}', 'delete');
        Route::patch('api/document/{id}', 'update');
    });

    Route::controller(ThematicController::class)->group(function () {
        Route::post('api/thematics', 'store');
    });
    Route::post('api/logout', [AuthController::class, 'logout']);
    Route::controller(ProjectController::class)->group(function () {
        Route::post('api/project', 'store');
        Route::post('api/project/objectives', 'objective');
        Route::post('api/project/results', 'result');
        Route::post('api/project/thematics', 'thematic');
        Route::delete('api/project/{id}', 'delete');
    });

    Route::controller(OrganizationController::class)->group(function () {
        Route::post('api/organizations', 'store');
        Route::patch('api/organization/{id}', 'update');
    });
});

Route::get('/login', function () {
    return response()->json(['message' => 'Please login'], 401);
})->name('login');
