<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use App\Models\RefreshToken;
use Illuminate\Support\Facades\Auth;
class EnsureHasAuthorizationHeader
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
   public function handle(Request $request, Closure $next)
    {
        if ($this->isPublicRoute($request)) {
            return $next($request);
        }

        $authHeader = $request->header('Authorization');
        if (!$authHeader || !str_starts_with($authHeader, 'Bearer ')) {
            return response()->json(['message' => 'Unauthorized: Bearer token missing'], 401);
        }

        $token = substr($authHeader, 7); // Remove 'Bearer ' prefix
        $tokenExists = RefreshToken::where('access_token', $token)
            ->where('access_token_expires_at', '>', now())
            ->first();
        // Validate token - implement your logic here
        if (!$tokenExists) {
            return response()->json(['message' => 'Unauthorized: Invalid token'], 401);
        }
        //Check if user is elligible to process
        /*$user = Auth::user();
        if (!$user) {
            return response()->json(['message' => 'Unauthorized'], 401);
        }

        print_r($user);*/

        // Proceed if valid
        return $next($request);
    }

    /**
     * Check if it's public route (No auth needed).
     */
    protected function isPublicRoute(Request $request): bool
    {
        $path = $request->path(); // ex: "docs"
        //echo $path;

        $query = $request->query(); // ex: ["api-docs.json" => ""]
        $publicPath=["api/phpinfo", "api/docs", "api/login", "api/locales", "docs/asset"]; // Exemple : autoriser Swagger UI et son JSON
        $publicDataPath=["api/projects", "api/project/objectives", "api/projects/results", "api/projects/thematics",
        "api/documents/public", "api/pictures", "api/organizations", "api/thematics", "api/spatial/legend"]; //Data with get method
        if (
            in_array($path, $publicPath) === true || str_contains($path, 'docs/asset') || str_contains($path, 'api/storage') ||
            array_key_exists('api-docs_json', $query) || ($request->isMethod('get') && (in_array($path, $publicDataPath) === true || str_contains($path, 'api/project')))
        ) {
            return true;
        }
        // Ajouter d'autres routes publiques ici si besoin
        return false;
    }
}
