/*
  Theme Name: WWF base on opensource template
  Author: WWF, Impact Monitoring Programme
  Author URL: https://wwf-congobasin-monitoring.org/
  Support: https://wwf-congobasin-monitoring.org/
  Description: CIBEL Web Platform.
  Version: 1.0
*/
$(function() {
  "use strict";
  //===== Prealoder
  $(window).on('load', function(event) {
      $('.preloader').delay(500).fadeOut(500);
  });

  //===== Search
  $('#search').on('click', function(){
      $(".search-box").fadeIn(600);
  });
  $('.closebtn').on('click', function(){
      $(".search-box").fadeOut(600);
  });

  //===== Sticky
  $(window).on('scroll', function(event) {
    var scroll = $(window).scrollTop();
    if (scroll < 245) {
      $(".navigation").removeClass("sticky");
      $(".header-three .navigation img").attr("src", "images/logo-2.png");
    } else{
      $(".navigation").addClass("sticky");
      $(".header-three .navigation img").attr("src", "images/logo.png");
    }
  });

  //===== Mobile Menu
  $(".navbar-toggler").on('click', function() {
      $(this).toggleClass("active");
  });
  var subMenu = $('.sub-menu-bar .navbar-nav .sub-menu');
  if(subMenu.length) {
    subMenu.parent('li').children('a').append(function () {
        return '<button class="sub-nav-toggler"> <i class="fa fa-chevron-down"></i> </button>';
    });
    var subMenuToggler = $('.sub-menu-bar .navbar-nav .sub-nav-toggler');
    subMenuToggler.on('click', function() {
        $(this).parent().parent().children('.sub-menu').slideToggle();
        return false
    });
  }

  //===== Slick Slider
  function mainSlider() {
    var BasicSlider = $('.slider-active');
    BasicSlider.on('init', function(e, slick) {
        var $firstAnimatingElements = $('.single-slider:first-child').find('[data-animation]');
        doAnimations($firstAnimatingElements);
    });
    BasicSlider.on('beforeChange', function(e, slick, currentSlide, nextSlide) {
        var $animatingElements = $('.single-slider[data-slick-index="' + nextSlide + '"]').find('[data-animation]');
        doAnimations($animatingElements);
    });
    BasicSlider.slick({
      autoplay: true,
      autoplaySpeed: 10000,
      pauseOnHover: false,
      dots: false,
      fade: true,
      arrows: true,
      prevArrow:'<span class="prev"><i class="fa fa-angle-left"></i></span>',
      nextArrow: '<span class="next"><i class="fa fa-angle-right"></i></span>',
      responsive: [
          { breakpoint: 767, settings: { dots: false, arrows: false } }
      ]
    });
    function doAnimations(elements) {
      var animationEndEvents = 'webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend';
      elements.each(function() {
        var $this = $(this);
        var $animationDelay = $this.data('delay');
        var $animationType = 'animated ' + $this.data('animation');
        $this.css({
            'animation-delay': $animationDelay,
            '-webkit-animation-delay': $animationDelay
        });
        $this.addClass($animationType).one(animationEndEvents, function() {
            $this.removeClass($animationType);
        });
      });
    }
  }
  mainSlider();
  //===== Slick Category Slide
  $('.category-slide').slick({
    dots: false,
    infinite: false,
    speed: 800,
    slidesToShow: 3,
    slidesToScroll: 1,
    arrows: true,
    prevArrow:'<span class="prev"><i class="fa fa-angle-left"></i></span>',
    nextArrow: '<span class="next"><i class="fa fa-angle-right"></i></span>',
    responsive: [
    {
      breakpoint: 922,
      settings: {
        slidesToShow: 3,
        slidesToScroll: 1,
      }
    },
    {
      breakpoint: 768,
      settings: {
        slidesToShow: 2,
        slidesToScroll: 1
      }
    },
    {
      breakpoint: 576,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1
      }
    }
    // You can unslick at a given breakpoint now by adding:
    // settings: "unslick"
    // instead of a settings object
    ]
  });

  //===== Slick Project Slide
  $('.project-slide').slick({
    dots: false,
    infinite: true,
    speed: 800,
    slidesToShow: 3,
    slidesToScroll: 1,
    autoplay: true,
    autoplaySpeed: 5000,
    arrows: true,
    prevArrow:'<span class="prev"><i class="fa fa-angle-left"></i></span>',
    nextArrow: '<span class="next"><i class="fa fa-angle-right"></i></span>',
    responsive: [
    {
      breakpoint: 1200,
      settings: {
        slidesToShow: 3,
        slidesToScroll: 1,
      }
    },
    {
      breakpoint: 992,
      settings: {
        slidesToShow: 2,
        slidesToScroll: 1,
      }
    },
    {
      breakpoint: 768,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1,
        arrows: false,
      }
    },
    // You can unslick at a given breakpoint now by adding:
    // settings: "unslick"
    // instead of a settings object
    ]
  });

  //===== Slick testimonial Slide
  $('.patnar-slide').slick({
    dots: false,
    infinite: true,
    autoplay: true,
    autoplaySpeed: 5000,
    speed: 800,
    slidesToShow: 4,
    slidesToScroll: 1,
    arrows: true,
    prevArrow:'<span class="prev patnar-prev"><i class="fa fa-angle-left"></i></span>',
    nextArrow: '<span class="next patnar-next"><i class="fa fa-angle-right"></i></span>',
    responsive: [
    {
      breakpoint: 1200,
      settings: {
        slidesToShow: 4,
        slidesToScroll: 1,
      }
    },
    {
      breakpoint: 992,
      settings: {
        slidesToShow: 3,
        slidesToScroll: 1
      }
    },
    {
      breakpoint: 768,
      settings: {
        slidesToShow: 2,
        slidesToScroll: 1
      }
    },
    {
      breakpoint: 576,
      settings: {
        slidesToShow: 2,
        slidesToScroll: 1
      }
    }
    // You can unslick at a given breakpoint now by adding:
    // settings: "unslick"
    // instead of a settings object
    ]
  });
  //===== Back to top
  // Show or hide the sticky footer button
  $(window).on('scroll', function(event) {
      if($(this).scrollTop() > 600){
          $('.back-to-top').fadeIn(200)
      } else{
          $('.back-to-top').fadeOut(200)
      }
  });


  //Animate the scroll to yop
  $('.back-to-top').on('click', function(event) {
      event.preventDefault();

      $('html, body').animate({
          scrollTop: 0,
      }, 1500);
  });
});
