<?php

namespace App\OpenApi;

use OpenApi\Annotations as OA;

/**
 * @OA\Info(
 *     title="API for CIBEL WEB Platform",
 *     version=CB_API_VERSION,
 *     description="API documentation for CIBEL Web Platform",
 *     @OA\Contact(
 *         name="Christian NGANWA",
 *         email="cnganwa@wwfcam.org"
 *     ),
 *     @OA\License(
 *         name="Common Creative Licence v4.0",
 *         url="https://creativecommons.org/"
 *     )
 * )
 *
 * @OA\SecurityScheme(
 *     securityScheme="bearerAuth",
 *     type="oauth2",
 *     scheme="bearer",
 *     bearerFormat="JWT",
 *     description="Paste token as: Bearer {token}",
 *     in="header",
 *     @OA\Flow(
 *         flow="password",
 *         tokenUrl=L5_SWAGGER_CONST_LOGIN,
 *         scopes={}
 *     )
 * )
 */
class SwaggerAnnotations {}
