<?php

namespace App\Http\Controllers;
use App\Models\Thematic;

use Illuminate\Http\Request;
/**
 * @OA\Tag(
 *     name="Thematics",
 *     description="Endpoints related to thematics management, such as creating, listing, and deleting thematics."
 * )
*/
class ThematicController extends Controller
{
    /**
     * @OA\Get(
     *     path="/api/thematics",
     *     summary="Get a list of thematics",
     *     tags={"Thematics"},
     *     @OA\Response(response=200, description="Successful operation"),
     *     @OA\Response(response=400, description="Invalid request")
     * )
     */
    public function index()
    {
        $data = Thematic::all();
        return response()->json([
            'status' => 'success',
            'data' => $data,
        ], 200); // 200 = OK
    }

    /**
     * @OA\Post(
     *     path="/api/thematics",
     *     tags={"Thematics"},
     *     security={{"bearerAuth":{}}},
     *     summary="Create a new thematic",
     *     @OA\RequestBody(
     *         required=true,
     *         @OA\JsonContent(
     *             required={"name"},
     *             @OA\Property(property="name", type="string", example="Thematic name"),
     *             @OA\Property(property="definition", type="string", example="Thematic definition"),
     *             @OA\Property(property="source", type="string", example="Thematic source"),
     *             @OA\Property(property="source_link", type="string", example="Thematic source link")
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Thematic created",
     *         @OA\JsonContent(
     *             @OA\Property(property="message", type="string"),
     *             @OA\Property(property="data", type="object",
     *                 @OA\Property(property="id", type="string"),
     *                 @OA\Property(property="name", type="string"),
     *                 @OA\Property(property="definition", type="text"),
     *                 @OA\Property(property="source", type="string"),
     *                 @OA\Property(property="source_link", type="string"),
     *                 @OA\Property(property="created_at", type="string"),
     *                 @OA\Property(property="updated_at", type="string")
     *             )
     *         )
     *     ),
     *     @OA\Response(response=401, description="Validation failed")
     * )
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string'
        ]);
        $data = Thematic::create([
            'name' => $request->name,
            'definition' => $request->definition,
            'source' => $request->source,
            'source_link' => $request->source_link
        ]);
        return response()->json([
            'message' => 'Thematic created successfully',
            'data' => $data,
        ], 200);
    }
}
